@echo off
setlocal ENABLEDELAYEDEXPANSION

REM Your Installation Directory
set "defaultDir=%ProgramFiles%"
set "defaultFolder=D300Kp_1.109.0.0"
set "destination=!defaultDir!\!defaultFolder!"

:silentInstall
REM Run Silent Install
set "curDir=%~dp0"
set "logDir=!destination!\SetupLog.txt"
set "exePath=!curDir!\D300Kp_Windows_Driver_1.109.0.0_ENG.exe"
!exePath! /verysilent

REM Output .bat run start time
call :startTime

:installStatus
REM Detecting Duplicate Installations
set "markFile=!destination!\marks"
if exist !markFile! (
    set /a lineNum=0
    for /f "usebackq delims=" %%a in ("!markFile!") do (
        set /a lineNum+=1
        set "line=%%a"
        call :checkMarksStatus !lineNum! !line! 0
		if !errorlevel! equ 0 (
			REM echo 2^>Verify: Detect Already Exists, exit installation.
			echo 2^>Verify: Detect Already Exists, exit installation.  >>!logDir!
			goto :endTime
		)
    )
)


REM VerifyFileIntegrity
REM Use Hash-Algorithm-MD5 to Verify
REM echo 0^>Verify: Hash Algorithm: MD5
echo 0^>Verify: Hash Algorithm: MD5 >>!logDir!
set /a "index=1"
set /a "fileSum=18"
set /a "fileEnd=fileSum+1"
set /a "fileCorrupted=0"

REM Key-MD5
set "_2k_ds300kpsm_EXE=cb0e93655f3cad0c79a5353ec8b63263"
set "_2k_DS300KP_DLL=5602b2bdb8785a9c64592d72465b58ba"
set "_2k_ds300kpcl_DLL=5d41736d24f84d027eca50761d36d4f8"
set "_2k_DS300KPRC_DLL=a46afad25583c402cfce6895bf700842"
set "_2k_DS300KPLM_DLL=b80c3a5bceca02a6b343f79e7524ad96"
set "_2k_DS300KPFM_DLL=ae9e28510f994515f3571ef5bde293b5"
set "_2k_DS300KPUI_DLL=ba0d7281afcec1f91db92176f74e67cc"
set "_64_ds300kpsm_EXE=e4df16968b6cd12c14e5442026aa78a3"
set "_64_DS300KP_DLL=f54bb70c9e0be3a28130e5081727e831"
set "_64_DS300kpcl_DLL=fd6b2bde12d5acac585111388853f197"
set "_64_DS300KPFM_DLL=b92ffa42daa662cf516692f34eac77ac"
set "_64_DS300KPLM_DLL=86cba7f5607ac48d36a4251944bf89f8"
set "_64_DS300KPRC_DLL=222e106b9b444832f50a7b4b832637a2"
set "_64_DS300KPUI_DLL=470897307ca1ec99606b4a57af29f5b4"
set "_i386_DS300KPTCPPortMon_DLL=2df2393301386ed93fb7457487a6b4b5"
set "_i386_DS300KPTCPPortMonUI_DLL=876916bde3e79985c944991ed5cd8ac4"
set "_x64_DS300KPTCPPortMon_DLL=ad79beadf305fd16da6d7cc4432e1a32"
set "_x64_DS300KPTCPPortMonUI_DLL=5e628a5576c2fffef698ea25b2faec54"

set "unzipPath=!destination!\Driver\Printer Driver"
set "_2kPath=2k"
set "_64Path=64"
set "_i386Path=TcpPortMon\i386"
set "_x64Path=TcpPortMon\x64"
set "ds300kpsm_EXE=ds300kpsm.exe"
set "DS300KP_DLL=DS300KP.dll"
set "ds300kpcl_DLL=ds300kpcl.dll"
set "DS300KPFM_DLL=DS300KPFM.dll"
set "DS300KPLM_DLL=DS300KPLM.dll"
set "DS300KPRC_DLL=DS300KPRC.dll"
set "DS300KPUI_DLL=DS300KPUI.dll"
set "DS300KPTCPPortMon_DLL=DS300KPTCPPortMon.dll"
set "DS300KPTCPPortMonUI_DLL=DS300KPTCPPortMonUI.dll"

:1
set "compareMD5=!_2k_ds300kpsm_EXE!"
set "verifyPath=!unzipPath!\!_2kPath!\!ds300kpsm_EXE!"
goto :VerifyFileIntegrity

:2
set "compareMD5=!_2k_DS300KP_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DS300KP_DLL!"
goto :VerifyFileIntegrity

:3
set "compareMD5=!_2k_ds300kpcl_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!ds300kpcl_DLL!"
goto :VerifyFileIntegrity

:4
set "compareMD5=!_2k_DS300KPRC_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DS300KPRC_DLL!"
goto :VerifyFileIntegrity

:5
set "compareMD5=!_2k_DS300KPLM_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DS300KPLM_DLL!"
goto :VerifyFileIntegrity

:6
set "compareMD5=!_2k_DS300KPFM_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DS300KPFM_DLL!"
goto :VerifyFileIntegrity

:7
set "compareMD5=!_2k_DS300KPUI_DLL!"
set "verifyPath=!unzipPath!\!_2kPath!\!DS300KPUI_DLL!"
goto :VerifyFileIntegrity

:8
set "compareMD5=!_64_ds300kpsm_EXE!"
set "verifyPath=!unzipPath!\!_64Path!\!ds300kpsm_EXE!"
goto :VerifyFileIntegrity

:9
set "compareMD5=!_64_DS300KP_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DS300KP_DLL!"
goto :VerifyFileIntegrity

:10
set "compareMD5=!_64_ds300kpcl_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!ds300kpcl_DLL!"
goto :VerifyFileIntegrity

:11
set "compareMD5=!_64_DS300KPRC_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DS300KPRC_DLL!"
goto :VerifyFileIntegrity

:12
set "compareMD5=!_64_DS300KPLM_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DS300KPLM_DLL!"
goto :VerifyFileIntegrity

:13
set "compareMD5=!_64_DS300KPFM_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DS300KPFM_DLL!"
goto :VerifyFileIntegrity

:14
set "compareMD5=!_64_DS300KPUI_DLL!"
set "verifyPath=!unzipPath!\!_64Path!\!DS300KPUI_DLL!"
goto :VerifyFileIntegrity

:15
set "compareMD5=!_i386_DS300KPTCPPortMon_DLL!"
set "verifyPath=!unzipPath!\!_i386Path!\!DS300KPTCPPortMon_DLL!"
goto :VerifyFileIntegrity

:16
set "compareMD5=!_i386_DS300KPTCPPortMonUI_DLL!"
set "verifyPath=!unzipPath!\!_i386Path!\!DS300KPTCPPortMonUI_DLL!"
goto :VerifyFileIntegrity

:17
set "compareMD5=!_x64_DS300KPTCPPortMon_DLL!"
set "verifyPath=!unzipPath!\!_x64Path!\!DS300KPTCPPortMon_DLL!"
goto :VerifyFileIntegrity

:18
set "compareMD5=!_x64_DS300KPTCPPortMonUI_DLL!"
set "verifyPath=!unzipPath!\!_x64Path!\!DS300KPTCPPortMonUI_DLL!"
goto :VerifyFileIntegrity

:VerifyFileIntegrity
REM echo 0^>Verify: File: !verifyPath!
echo 0^>Verify: File: !verifyPath! >> !logDir!
for /f "delims=" %%a in ('
    certutil -hashfile "!verifyPath!" MD5 ^| findstr /r "[0-9a-f]" ^| findstr /v "CertUtil"
') do (
    set "ret=%%a"
)
if not !ret!==!compareMD5! (
	set /a "fileCorrupted+=1"
    REM echo 2^>Verify - Result: [Corrupted], File -^> !verifyPath!
    echo 2^>Verify - Result: [Corrupted], File -^> !verifyPath! >>  !logDir!
) 
set /a "index+=1"
if !index! equ !fileEnd! (
	goto :VerifyEnd
) else (
	goto :!index!
)

:VerifyEnd
set "dataTime=%time%"
if !fileCorrupted! equ 0 (
REM echo 0^>Verify: Corrupted file count: !fileCorrupted!
echo 0^>Verify: Corrupted file count: !fileCorrupted! >>!logDir!
) else (
REM echo 2^>Verify: Corrupted file count: !fileCorrupted!
echo 2^>Verify: Corrupted file count: !fileCorrupted! >>!logDir!
)
goto :endTime

:checkMarksStatus
setlocal
set lineNum=%1
set line=%2
set num=%3
set /a "groupNum=num/32 + 1"
if !groupNum! neq !lineNum! (
    endlocal & exit /b 1
)
set /a "bitMask=1<<(num%%32)"
set "hexValue=!line:0x=!"
set /a decValue=0x!hexValue!
set /a "result=decValue & bitMask"
if !result! neq 0 (
    endlocal & exit /b 0
) else (
    endlocal & exit /b 1
)

:startTime
set "dateTime=%time%"
REM echo 0^>Verify: Start time: !dateTime!
echo 0^>Verify: Start time: !dateTime! >>!logDir!
goto :eof

:endTime
set "dateTime=%time%"
REM echo 0^>Verify: Finish time: !dateTime!
echo 0^>Verify: Finish time: !dateTime! >>!logDir!
echo. >> !logDir!
goto :eof

