// FTPCSC.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "jni.h"
#include "FTPCSCLoader.h"

//boolean		"Z"
//char			"C"
//double		"D"
//int			"I"
//byte[]		"[B"
//String		"Ljava/lang/String;"

///////////////////////////////////////////////////////////////////////////////
// PCSC Support.
#include "winscard.h"
#pragma comment (lib, "winscard.lib")

SCARDCONTEXT nContext = 0 ;

ULONG  ResponseLength;

#define			MAX_RESPONSE		1024
#define			MAX_APDU_LEN		1024

typedef		struct STU_Reader{
	char	szReaderName[MAX_PATH];
}SCReader, *PSCReader;

BYTE  pResponseBuffer[MAX_RESPONSE];
SCARDCONTEXT  ContextHandle;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardEstablishContext
(JNIEnv *env, jobject obj, jint dwScope , jint pvReserved1, jint pvReserved2, jint hContext){

	jclass FTPCSCLoader =env->GetObjectClass(obj);    
	
	jfieldID fid_hContext = env->GetFieldID(FTPCSCLoader, "m_hContext", "I") ;
	if (fid_hContext == NULL)
	{ return -1 ; }

	DWORD ret =  SCardEstablishContext(dwScope, NULL, NULL, &nContext);
	if (ret == SCARD_S_SUCCESS) 
	{
		env->SetIntField(obj, fid_hContext, (jint)nContext);
	}

	return ret ;
}

JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardListReaders
(JNIEnv *env, jobject obj, jint hContext , jint mszGroups, jbyteArray szReaders, jint pcchReaders){

	jclass class_Test=env->GetObjectClass(obj);    
	
	jfieldID fid_cchReaders = env->GetFieldID(class_Test, "m_cchReaders", "I") ;
	if (fid_cchReaders == NULL)
	{ return -1 ; }

	jfieldID fid_szReader = env->GetFieldID(class_Test, "m_szReader", "[B") ;
	if (fid_szReader == NULL)
	{ return -2 ; }

	jbyteArray jbd = (jbyteArray)env->GetObjectField(obj, fid_szReader);
	jsize nArrLen = env->GetArrayLength(jbd);

	ResponseLength = MAX_RESPONSE ;
	DWORD ret = SCardListReaders(hContext, 0, (char *)pResponseBuffer, &ResponseLength);
	if (ret == SCARD_S_SUCCESS) 
	{
		jbyteArray jarr = env->NewByteArray(ResponseLength);  
		jbyte *jby = env->GetByteArrayElements(jarr, 0); 
		
		memcpy(jby, pResponseBuffer, ResponseLength-1) ;
		env->SetByteArrayRegion(jbd, 0, ResponseLength, jby); 
		env->SetIntField(obj, fid_cchReaders, (jint)ResponseLength);

		env->ReleaseByteArrayElements(jarr, jby, 0) ;
	}

	return ret;
}


JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardConnect
(JNIEnv *env, jobject obj, jint hContext, jbyteArray szReader, jint dwShareMode, jint dwPreferredProtocols, jint phCard, jint pdwActiveProtocol){


	DWORD				ActiveProtocol;
    SCARDHANDLE			CardHandle; 

	jclass class_Test=env->GetObjectClass(obj);    
	
	jfieldID fid_hCard = env->GetFieldID(class_Test, "m_hCard", "I") ;
	if (fid_hCard == NULL)
	{ return -1 ; }
	
	jfieldID fid_dwActiveProtocols = env->GetFieldID(class_Test, "m_dwActiveProtocols", "I") ;
	if (fid_dwActiveProtocols == NULL)
	{ return -2 ; }
	
	jbyte *jby = env->GetByteArrayElements(szReader, 0) ;

    DWORD ret = SCardConnect(hContext, (char*)jby, SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0 | SCARD_PROTOCOL_T1, 
		&CardHandle, &ActiveProtocol);
	
	if (ret == SCARD_S_SUCCESS)
    {
		env->SetIntField(obj, fid_hCard, (jint)CardHandle);
		env->SetIntField(obj, fid_dwActiveProtocols, (jint)ActiveProtocol);
	}

	return ret;
}


JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardTransmit
(JNIEnv * env, jobject obj, jint hCard, jintArray pioSendPci, jbyteArray pbSendBuffer, jint cbSendLength, 
jintArray pioRecvPci, jbyteArray pbRecvBuffer, jint pcbRecvLength){

	jclass class_Test = env->GetObjectClass(obj);

	char SendData[MAX_APDU_LEN] = {0};
	char ReceiveData[MAX_RESPONSE] = {0};
	ULONG nCmdLen, nResp;	
	SCARD_IO_REQUEST IO_Request;
    
	if (pbSendBuffer == NULL || cbSendLength > MAX_APDU_LEN)
	{ return -1 ; }

	jint* pjnIoSendPci = env->GetIntArrayElements(pioSendPci, 0) ;
	if (pjnIoSendPci == NULL)
	{ return -2 ; }
	
	jfieldID fid_RecvBuffer = env->GetFieldID(class_Test, "m_bRecvBuffer", "[B") ;
	if (fid_RecvBuffer == NULL)
	{ return -3 ; }

	jfieldID fid_bRecvLength = env->GetFieldID(class_Test, "m_cbRecvLength", "I") ;
	if (fid_bRecvLength == NULL)
	{ return -4 ; }
	
	jbyteArray jbd = (jbyteArray)env->GetObjectField(obj, fid_RecvBuffer);
	jsize nArrLen = env->GetArrayLength(jbd);

	jbyte* pjbSendbuffer = env->GetByteArrayElements(pbSendBuffer, 0) ;
	
	ZeroMemory(ReceiveData, MAX_APDU_LEN);
    nResp = MAX_RESPONSE;
	IO_Request.dwProtocol = pjnIoSendPci[0];
	IO_Request.cbPciLength = pjnIoSendPci[1];

	memcpy(SendData, pjbSendbuffer, cbSendLength) ;

	DWORD ret = SCardTransmit(hCard, &IO_Request, (PUCHAR)SendData, cbSendLength, 0, (PUCHAR)ReceiveData, &nResp);
	if (ret == SCARD_S_SUCCESS)
    {
		jbyteArray jarr = env->NewByteArray(ResponseLength);  
		jbyte *jby = env->GetByteArrayElements(jarr, 0); 
		memcpy(jby, ReceiveData, nResp-1) ;
		env->SetByteArrayRegion(jbd, 0, ResponseLength, jby);
		env->SetIntField(obj, fid_bRecvLength, (jint)nResp);

		env->ReleaseByteArrayElements(jarr, jby, 0) ;
	}
	
	return ret;
}


JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardGetStatusChange
(JNIEnv * env, jobject obj, jint hContext, jint dwTimeout, jint cReaders, jbyteArray RdrName, jint UserData, jint RdrCurrState, jint RdrEventState, jint ATRLength, jbyteArray pbATR){

	SCARD_READERSTATE RdrState;
	jclass class_Test = env->GetObjectClass(obj);

	jfieldID fid_rsUserData = env->GetFieldID(class_Test, "m_rsUserData", "I") ;
	if (fid_rsUserData == NULL)
	{ return -1 ; }

	jfieldID fid_rsRdrCurrState = env->GetFieldID(class_Test, "m_rsRdrCurrState", "I") ;
	if (fid_rsRdrCurrState == NULL)
	{ return -2 ; }

	jfieldID fid_rsRdrEventState = env->GetFieldID(class_Test, "m_rsRdrEventState", "I") ;
	if (fid_rsRdrEventState == NULL)
	{ return -3 ; }

	jfieldID fid_rsATRLength = env->GetFieldID(class_Test, "m_rsATRLength", "I") ;
	if (fid_rsATRLength == NULL)
	{ return -4 ; }

	jfieldID fid_rsATRValue	= env->GetFieldID(class_Test, "m_rsATRValue", "[B") ;
	if (fid_rsATRValue == NULL)
	{ return -4 ; }

	jbyteArray jbd = (jbyteArray)env->GetObjectField(obj, fid_rsATRValue);
	jsize nArrLen = env->GetArrayLength(jbd);

	jbyte* readerName = env->GetByteArrayElements(RdrName, 0) ;
	RdrState.szReader = (char*)readerName ;
	DWORD ret = SCardGetStatusChange(hContext, dwTimeout, &RdrState, cReaders);
	if (ret == SCARD_S_SUCCESS)
    {

		env->SetIntField(obj, fid_rsUserData, (int)RdrState.pvUserData) ;
		env->SetIntField(obj, fid_rsRdrCurrState, RdrState.dwCurrentState) ;
		env->SetIntField(obj, fid_rsRdrEventState, RdrState.dwEventState) ;
		env->SetIntField(obj, fid_rsATRLength, RdrState.cbAtr) ;

		jbyteArray jarr = env->NewByteArray(RdrState.cbAtr);  
		jbyte *jby = env->GetByteArrayElements(jarr, 0); 
		memcpy(jby, RdrState.rgbAtr, RdrState.cbAtr) ;
		env->SetByteArrayRegion(jbd, 0, RdrState.cbAtr, jby);

		env->ReleaseByteArrayElements(jarr, jby, 0) ;
	}
		
	return ret ;
}

JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardDisconnect
(JNIEnv * env, jobject obj, jint hCard, jint dwDisposition){

	DWORD ret = SCardDisconnect(hCard, dwDisposition);
	return ret ;
}

JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardReleaseContext
(JNIEnv * env, jobject obj, jint hContext){

	DWORD ret = SCardReleaseContext(hContext);
	return ret ;
}

JNIEXPORT jint JNICALL Java_FTPCSCLoader_SCardStatus
  (JNIEnv * env, jobject obj, jint hCard, jbyteArray mszReaderNames, jint pcchReaderLen, jint pdwState , jint pdwProtocol, jbyteArray pbATR, jint pcbAtrLen)
{

	BYTE ATRVal[128];
	DWORD ATRLen ;
	DWORD ReaderLen = 100, dwState;
	DWORD tempword;
	char tempstr[255]={0};

	tempword = 32;
	ATRLen = tempword;

	jclass class_Test = env->GetObjectClass(obj);

	jfieldID fid_cchReaderLen = env->GetFieldID(class_Test, "m_cchReaderLen", "I") ;
	if (fid_cchReaderLen == NULL)
	{ return -1 ; }

	jfieldID fid_dwState = env->GetFieldID(class_Test, "m_dwState", "I") ;
	if (fid_dwState == NULL)
	{ return -1 ; }

	jfieldID fid_dwProtocol = env->GetFieldID(class_Test, "m_dwProtocol", "I") ;
	if (fid_dwProtocol == NULL)
	{ return -1 ; }
	

	jfieldID fid_cbAtrLen = env->GetFieldID(class_Test, "m_cbAtrLen", "I") ;
	if (fid_cbAtrLen == NULL)
	{ return -1 ; }

	jfieldID fid_rsATRValue = env->GetFieldID(class_Test, "m_rsATRValue", "[B") ;
	if (fid_rsATRValue == NULL)
	{ return -3 ; }

	jbyteArray jbd = (jbyteArray)env->GetObjectField(obj, fid_rsATRValue);
	jsize nArrLen = env->GetArrayLength(jbd);
	
	
	//Invoke SCardStatus using hCard handle and valid reader name

	jbyte *readerName = env->GetByteArrayElements(mszReaderNames, 0) ;

	DWORD ret = SCardStatus( hCard,
		(char*)readerName,
		&ReaderLen,
		&dwState,
		(unsigned long *)&pdwProtocol,
		ATRVal,
		&ATRLen );
	
	if( ret == SCARD_S_SUCCESS )
	{
		env->SetIntField(obj, fid_cchReaderLen, ReaderLen) ;
		env->SetIntField(obj, fid_dwState, dwState) ;
		env->SetIntField(obj, fid_dwProtocol, pdwProtocol) ;
		env->SetIntField(obj, fid_cbAtrLen, ATRLen) ;

		jbyteArray jarr = env->NewByteArray(128);  
		jbyte *jby = env->GetByteArrayElements(jarr, 0); 
		memcpy(jby, ATRVal, ATRLen) ;
		env->SetByteArrayRegion(jbd, 0, ATRLen, jby);
		
		env->ReleaseByteArrayElements(jarr, jby, 0) ; 
	}

	return ret ;
}