/**
 * @(#)FTPcscLoader.java
 *
 *
 * @author 
 * LYL
 *
 * @version 1.00 2015/03/05
 */


public class FTPCSCLoader {
	
	
	private int m_hContext, m_cchReaders, m_hCard, m_dwActiveProtocols, m_cbRecvLength; 
	private int m_cbAtrLen, m_dwState, m_dwProtocol;
	private int m_cchReaderLen, m_lpBytesReturned;
	private int m_rsUserData, m_rsRdrEventState, m_rsATRLength, m_rsRdrCurrState;	
	private int m_ret = 0;
	private byte[] m_szReader = new byte[512] ;
	private byte[] m_bRecvBuffer = new byte[1024] ;
	private byte[] m_rsATRValue = new byte[36] ;
	
    public FTPCSCLoader() {
    }
    
    // PCSC WRAPPER FUNCTIONS **********************************************************************
    
    
    public int jSCardEstablishContext(int dwscope, int pvReserved1, int pvReserved2, int [] phContext)						 						
	{				 								
		int ret = SCardEstablishContext(dwscope, pvReserved1, pvReserved2, m_hContext);			
		phContext[0] = m_hContext; //return value of hContext;	 			
		return ret;						 						
	};
	
	public int jSCardReleaseContext(int [] phContext)
	{
		int ret = SCardReleaseContext(phContext[0]);
		return ret;
	};
	
	public int jSCardListReaders(int [] phContext, int mszGroups, byte[] szReaders, int [] pcchReaders)
	{
		
		m_hContext = phContext[0] ;
		int ret = SCardListReaders(m_hContext, 0, m_szReader, m_cchReaders);
		pcchReaders[0] = m_cchReaders; //return value of cchReaders
		
		int i = 0 ;
		for(i=0; i< m_cchReaders;i++){
			
			szReaders[i] = m_szReader[i] ;
		}
		String readerName = new String(m_szReader, 0, m_cchReaders ) ;
		
		System.out.println("readerName:"+readerName);
		return ret;
	};
	
	public int jSCardConnect(int [] phContext, String myReader, int dwShareMode, 
			int dwPreferredProtocols, int [] phCard, int [] pdwActiveProtocols)
	{
		byte [] tmpReader	= myReader.getBytes();
		byte [] szReader	= new byte[myReader.length()+1];
		
		for (int i=0; i<myReader.length(); i++)
		szReader[i] = tmpReader[i];
		szReader[myReader.length()] = 0; //set null terminator
		
		int ret = SCardConnect(phContext[0], szReader, dwShareMode, dwPreferredProtocols, m_hCard, m_dwActiveProtocols);
		
		System.out.println("ret:"+ ret);
		System.out.println("m_hCard:"+ m_hCard);
		System.out.println("m_dwActiveProtocols:"+ m_dwActiveProtocols);
		
		phCard[0] = m_hCard;
		pdwActiveProtocols[0] =  m_dwActiveProtocols;
		return ret;							 		
	};
	
	public int jSCardDisconnect(int [] phCard, int dwDisposition)			   				 	
	{
		int ret = SCardDisconnect(phCard[0], dwDisposition);
		return ret;	
	};				 
	
	
	public int jSCardTransmit(int [] phCard, FTModule.SCARD_IO_REQUEST pioSendPci,
			byte[] pbSendBuffer, int cbSendLength, FTModule.SCARD_IO_REQUEST pioRecvPci, 
			byte[] pbRecvBuffer, int [] pcbRecvLength)
				
	{
		int ret = -1 ;
		try 
		{
			int[] ioSendPci = new int[2] ;
			int[] ioRecvPci = new int[2] ;
			ioSendPci[0] = pioSendPci.dwProtocol ;
			ioSendPci[1] = pioSendPci.cbPciLength ;
			
			ioRecvPci[0] = 0;
			ioRecvPci[1] = 0;
			m_cbRecvLength = pcbRecvLength[0];		
			ret = SCardTransmit(phCard[0], ioSendPci, pbSendBuffer, cbSendLength, ioRecvPci, 
						pbRecvBuffer, m_cbRecvLength);
			
			for(int i=0; i<m_cbRecvLength; i++){
				pbRecvBuffer[i] = m_bRecvBuffer[i] ;
			}
			pcbRecvLength[0] = m_cbRecvLength;						
		
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return ret;		
	};
	
	public int jSCardStatus(int [] phCard, byte[] mszReaderNames, int [] pcchReaderLen, int [] pdwState,
            int [] pdwProtocol, byte[] pbATR, int [] pcbAtrLen)
	{       
		int ret = -1 ;
		m_cchReaderLen = pcchReaderLen[0];
		m_dwState = pdwState[0];
		m_dwProtocol = pdwProtocol[0];
		m_cbAtrLen = pcbAtrLen[0];  
	
		try 
		{
			ret = SCardStatus(phCard[0], mszReaderNames, m_cchReaderLen, m_dwState, m_dwProtocol, pbATR, m_cbAtrLen);
			
			if (ret == FTModule.SCARD_S_SUCCESS)   
			{   
				pcchReaderLen[0] = m_cchReaderLen;
				pdwState[0] = m_dwState;
				pdwProtocol[0] = m_dwProtocol;
				pcbAtrLen[0] = m_cbAtrLen;
				
				for(int i=0; i<m_cbAtrLen; i++){
					pbATR[i] = m_rsATRValue[i] ;
				}
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		} 
		return ret;
	};
	
	
	public int jSCardGetStatusChange(int [] phContext, int dwTimeout, FTModule.SCARD_READERSTATE rgReaderStates, int cReaders)
    {
		int ret = -1 ;
		String strRdr = rgReaderStates.RdrName;
		
		try 
		{
			
			byte [] RdrName;	
			if (strRdr != null)
			{			
				byte [] tmpReader = strRdr.getBytes();
		        RdrName = new byte[strRdr.length()+1];	      
			    for (int i=0; i<strRdr.length(); i++)
			      RdrName[i] = tmpReader[i];
			    RdrName[strRdr.length()] = 0; //set null terminator
			} else {
				RdrName  = new byte[256];
				RdrName[0] = 0;	     
			}
			if (rgReaderStates.ATRValue == null)
			{
				rgReaderStates.ATRValue = new byte[36];
			}	
			
			for(int j=0; j<m_rsATRValue.length; j++)
			{
				m_rsATRValue[j] = 0x00;
			}
		
			//private static int rsUserData, rsRdrCurrState, rsRdrEventState, rsATRLength;
			ret = SCardGetStatusChange(phContext[0], dwTimeout, cReaders, 			                       			                       
				                       RdrName, 				//----------
				                       m_rsUserData,              //
				                       m_rsRdrCurrState,			//  SCARD_READERSTATE structure variables		
				                       m_rsRdrEventState,			//
				                       m_rsATRLength,				//
				                       rgReaderStates.ATRValue);//----------		
				                       	
			//rgReaderStates.RdrName = new String(RdrName);
			rgReaderStates.UserData = m_rsUserData;
			rgReaderStates.RdrCurrState = m_rsRdrCurrState;
			rgReaderStates.RdrEventState = m_rsRdrEventState;
			rgReaderStates.ATRLength = m_rsATRLength;	
			
			for(int i=0; i<m_rsATRLength; i++){
				rgReaderStates.ATRValue[i] = m_rsATRValue[i] ;
			}
			
			System.out.println("m_rsATRLength: " + m_rsATRLength + " m_rsATR: " + m_rsATRValue);
			
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return ret;
	};

	//PCSC JNI FUNCTIONS *************************************************************************
	
	private native int SCardEstablishContext(int dwscope, int pvReserved1, int pvReserved2, int phContext);
	
	private native int SCardReleaseContext(int hContext);
	
	private native int SCardListReaders(int phContext, int mszGroups, byte[] szReaders, int pcchReaders);

	private native int SCardConnect(int hContext, byte[] szReaders, int dwShareMode, int dwPreferredProtocols,
					   				int phCard, int pdwActiveProtocols);

	private native int SCardReconnect(int hContext, int dwShareMode, int dwPreferredProtocols, int dwInitialization,
					   				 int pdwActiveProtocols);

	private native int SCardDisconnect(int hCard, int dwDisposition);

	private native int SCardBeginTransaction(int hCard);

	private native int SCardEndTransaction(int hCard, int dwDisposition);

	private native int SCardState(int hCard, int pdwState, int pdwProtocol, byte[] pbATR, int pcbAtrLen);

	private native int SCardGetStatusChange(int hContext, int dwTimeout,  int cReaders, byte [] RdrName,
                    						int UserData, int RdrCurrState, int RdrEventState, int ATRLength,
                    						byte [] pbATR); 
                    						
	private native int SCardStatus(int hCard, byte [] mszReaderNames, int pcchReaderLen, int pdwState,
                      			   int pdwProtocol, byte[] pbATR, int pcbAtrLen);


	private native int SCardTransmit(int hCard, int[] pioSendPci, byte[] pbSendBuffer,
									int cbSendLength, int[] pioRecvPci, byte[] pbRecvBuffer,
									int pcbRecvLength);


	private native int SCardControl(int hCard, int dwControlCode, byte[] lpInBuffer, int nInBufferSize,
								   byte[] lpOutBuffer, int nOutBufferSize, int lpBytesReturned); 

    static {
       System.loadLibrary("FTPCSC");
    }
	
}