import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JTextArea;
import javax.swing.Timer ;
import java.awt.event.*;
import java.awt.Label;
import java.awt.Font;



public class SimplePCSC extends JFrame implements ActionListener {

	private JFrame frame;
	private JTextField tAPDUInput;
	private JButton btnListReaders ;
	private JButton btnConnect ;
	private JButton btnTransmit ;
	private JButton btnStartPpolling ;
	private JButton btnStopPpolling ;
	private JButton btnDisconnect ;
	private JButton btnReleaseContext ;
	private JComboBox cbReader ;
	private JTextArea mMsg ;
	private JButton btnStatus;
	private JButton btnClear;
	
	Timer timer;
	int retCode ;
	int [] hContext 		= new int[1];
	int [] cchReaders 		= new int[1];
	int [] hCard 			= new int[1];
	int [] PrefProtocols 	= new int[1];
	int [] RecvLen 			= new int[1];
	int [] ATRLen 			= new int[1]; 
	int SendLen 			= 0;
	byte [] SendBuff		= new byte[300];
	byte [] RecvBuff 		= new byte[300];
	byte [] ATRVal 			= new byte[128];
	byte [] szReaders 		= new byte[1024];
	
	static FTPCSCLoader PCSCLoader = new FTPCSCLoader();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					SimplePCSC window = new SimplePCSC();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public SimplePCSC() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBounds(100, 100, 621, 582);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().setLayout(null);
		
		btnListReaders = new JButton("SCardListReaders");
		btnListReaders.setBounds(379, 50, 153, 37);
		frame.getContentPane().add(btnListReaders);
		btnListReaders.addActionListener(this);
		
		btnConnect = new JButton("SCardConnect");
		btnConnect.setEnabled(false);
		btnConnect.setBounds(379, 108, 153, 37);
		frame.getContentPane().add(btnConnect);
		btnConnect.addActionListener(this);
		
		btnTransmit = new JButton("SCardTransmit");
		btnTransmit.setEnabled(false);
		btnTransmit.setBounds(379, 163, 153, 37);
		frame.getContentPane().add(btnTransmit);
		btnTransmit.addActionListener(this);
		
		btnStartPpolling = new JButton("StartPpolling");
		btnStartPpolling.setEnabled(false);
		btnStartPpolling.setBounds(379, 275, 153, 37);
		frame.getContentPane().add(btnStartPpolling);
		btnStartPpolling.addActionListener(this);
		
		btnStopPpolling = new JButton("StopPpolling");
		btnStopPpolling.setEnabled(false);
		btnStopPpolling.setBounds(379, 334, 153, 37);
		frame.getContentPane().add(btnStopPpolling);
		btnStopPpolling.addActionListener(this);
		
		btnDisconnect = new JButton("SCardDisconnect");
		btnDisconnect.setEnabled(false);
		btnDisconnect.setBounds(379, 381, 153, 37);
		frame.getContentPane().add(btnDisconnect);
		btnDisconnect.addActionListener(this);
		
		btnReleaseContext = new JButton("SCardReleaseContext");
		btnReleaseContext.setEnabled(false);
		btnReleaseContext.setBounds(379, 438, 153, 37);
		frame.getContentPane().add(btnReleaseContext);
		btnReleaseContext.addActionListener(this);
		
		btnStatus = new JButton("SCardStatus");
		btnStatus.setEnabled(false);
		btnStatus.setBounds(379, 225, 153, 37);
		frame.getContentPane().add(btnStatus);
		btnStatus.addActionListener(this);
		
		btnClear = new JButton("Clear Output Window");
		btnClear.setBounds(38, 449, 153, 37);
		frame.getContentPane().add(btnClear);
		btnClear.addActionListener(this);
		
		cbReader = new JComboBox();
		cbReader.setBounds(38, 54, 290, 28);
		frame.getContentPane().add(cbReader);
		
		tAPDUInput = new JTextField();
		tAPDUInput.setBounds(38, 132, 290, 28);
		frame.getContentPane().add(tAPDUInput);
		tAPDUInput.setColumns(10);
		
		mMsg = new JTextArea();
		mMsg.setFont(new Font("Monospaced", Font.BOLD, 13));
		mMsg.setEnabled(false);
		mMsg.setBounds(38, 203, 290, 232);
		frame.getContentPane().add(mMsg);
		
		Label label = new Label("Data Output");
		label.setBounds(38, 177, 79, 23);
		frame.getContentPane().add(label);
		
		label_1 = new Label("APDU Input");
		label_1.setBounds(38, 108, 69, 23);
		frame.getContentPane().add(label_1);
		
		
	}
	
	private String byteArrayToHexString(byte[] bbuffer, int nbufferlength )
	{
		StringBuffer sb = new StringBuffer(bbuffer.length * 2);
		for (int i = 0; i < nbufferlength; i++) {
			int v = bbuffer[i] & 0xff;
			if (v < 16) {
				sb.append('0');
				}
			sb.append(Integer.toHexString(v));
			}
		return sb.toString().toUpperCase();
	}

	private static int hexStringToByteArray(String s, byte[] data)
	{
		int len = s.length();
		
		for (int i = 0; i < len; i += 2) {
			data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i+1), 16));
			}
		
		return len/2;
	}
	
	public void displayOut(int mType, int msgCode, String printText)
	{

		//mMsg.setText("");
		switch(mType)
		{
		
			case 1: 
				{
					
					mMsg.append("! " + printText);
					mMsg.append(FTModule.GetScardErrMsg(msgCode) + "\n");
					break;
					
				}
			case 2: mMsg.append("< " + printText + "\n");break;
			case 3: mMsg.append("> " + printText + "\n");break;
			case 4: mMsg.append("- " + printText + "\n");break;
			default: {
				mMsg.append("- " + printText + "\n");break;
			}
		
		}
		
	}
	
	public void clearBuffers()
	{
		for(int i=0; i<300; i++)
		{
			SendBuff[i]=0x00;
			RecvBuff[i]=0x00;
		}	
	}
	
	public boolean checkCard()
	{
	
		FTModule.SCARD_READERSTATE readerState = new FTModule.SCARD_READERSTATE();
		String rdrcon= (String)cbReader.getSelectedItem();  
		readerState.RdrName = rdrcon;
	      
  	    retCode = PCSCLoader.jSCardGetStatusChange(hContext, 
  	    						0, 
  	    						readerState, 
  	    						1); 
  	  					
  	  //JOptionPane.showMessageDialog(this, retCode);
  	    if(retCode != FTModule.SCARD_S_SUCCESS)
  		{
  	    	
  	    	System.out.println(FTModule.GetScardErrMsg(retCode));
  	    	return false;
  	    	
  		}
  	    else
  	    {
  	    	if((readerState.RdrEventState/32)%2!=0)
  	    		return true;
  	    	else
  	    		return false;
  	    	
  	    }
		
		
	}
	
	//timer for automatic polling
	ActionListener pollTimer = new ActionListener() {
	      public void actionPerformed(ActionEvent evt) {
	    	
	    	  mMsg.setText("");
	    	  if(checkCard())
	    		  	displayOut(5, 0,"Card inserted");
		    	  else
		    		displayOut(5, 0,"Card removed");
		
		}
	};
	private Label label_1;
		
	public int sendAPDUandDisplay()
	{
		
		FTModule.SCARD_IO_REQUEST IO_REQ = new FTModule.SCARD_IO_REQUEST(); 
		FTModule.SCARD_IO_REQUEST IO_REQ_Recv = new FTModule.SCARD_IO_REQUEST(); 
		IO_REQ.dwProtocol = PrefProtocols[0];
		IO_REQ.cbPciLength = 8;
		IO_REQ_Recv.dwProtocol = PrefProtocols[0];
		IO_REQ_Recv.cbPciLength = 8;
		RecvLen[0] = 262;
		
		retCode = PCSCLoader.jSCardTransmit(hCard, 
									 IO_REQ, 
									 SendBuff, 
									 SendLen, 
									 null, 
									 RecvBuff, 
									 RecvLen);
		
		if (retCode != FTModule.SCARD_S_SUCCESS)
		{
			return retCode;
			
		}
		
		return retCode;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		if(btnListReaders == e.getSource()){
			
			System.out.println("btnListReaders");
			
			// Establish Context
			retCode = PCSCLoader.jSCardEstablishContext(FTModule.SCARD_SCOPE_USER, 0, 0, hContext);
			if (retCode != FTModule.SCARD_S_SUCCESS)
		    {
				mMsg.append("Calling SCardEstablishContext...FAILED\n");
		      	displayOut(1, retCode, "");
		    }
			
			// List PC/SC card readers installed in the system
			retCode = PCSCLoader.jSCardListReaders(hContext, 0, szReaders, cchReaders);
			if (retCode != FTModule.SCARD_S_SUCCESS)
		    {
				mMsg.append("Calling CardListReaders...FAILED\n");
		      	displayOut(1, retCode, "");
		      	
		    }
			else
			{
				int offset = 0;
				cbReader.removeAllItems();
				
				for (int i = 0; i < cchReaders[0]-1; i++)
				{
					
				  	if (szReaders[i] == 0x00)
				  	{			  		
				  		cbReader.addItem(new String(szReaders, offset, i - offset));
				  		offset = i+1;
				  	}
				}
				
				if (cbReader.getItemCount() == 0)
				{
					cbReader.addItem("No reader detected");
					return;
				}
				else
				{
					mMsg.append("SCardListReaders SUCCESS\n");
				}
				
				btnListReaders.setEnabled(false);
				
				btnConnect.setEnabled(true);
				btnStartPpolling.setEnabled(true);
				btnReleaseContext.setEnabled(true);
				
			}
		}
		else if(btnConnect == e.getSource()){
			
			System.out.println("btnConnect");
			
			String rdrcon = (String)cbReader.getSelectedItem();  	      	      	
		    
			// Connect 
		    retCode = PCSCLoader.jSCardConnect(hContext, 
		    							rdrcon, 
		    							FTModule.SCARD_SHARE_EXCLUSIVE,
		    							FTModule.SCARD_PROTOCOL_T1 | FTModule.SCARD_PROTOCOL_T0,
		      							hCard, 
		      							PrefProtocols);
		    
		    if (retCode != FTModule.SCARD_S_SUCCESS)
		    {
		    	displayOut(1, retCode, "");
		    	return;
		    } 
		    else 
		    {	    
		    	displayOut(0, 0, "Successful connection to " + (String)cbReader.getSelectedItem());
		    	
		    	btnConnect.setEnabled(false);
		    	btnStartPpolling.setEnabled(false);
		    	
		    	btnTransmit.setEnabled(true);
		    	btnDisconnect.setEnabled(true);
		    	btnStatus.setEnabled(true);
		    }
		}
		else if(btnTransmit == e.getSource()){
			
			System.out.println("btnTransmit");
			
			String tmpStr="", tmpVal="", tmpHex="";
			boolean diFlag=false;
			
			if(tAPDUInput.getText().equals(""))
			{
			
				displayOut(0, 0, "no data input");
				tAPDUInput.requestFocus();
				return;
			
			}
			
			tmpVal = tAPDUInput.getText().trim();
			
			for(int i=0; i<tmpVal.length(); i++)
			{
				
				if(tmpVal.charAt(i) != (char)32)
				{
					tmpStr = tmpStr + tmpVal.charAt(i);
				}
				
			}
			
			if((tmpStr.length() % 2)!=0)
			{
				diFlag = true;
			}
			
			if( tmpStr.length() < 10 )
			{
				
				displayOut(0, 0, "Insufficient data input\n");
				tAPDUInput.requestFocus();
				return;
				
			}
			
			if (diFlag)
			{
				
				displayOut(0, 0, "Invalid data input, uneven number of characters");
				tAPDUInput.requestFocus();
				return;
				
			}
			
			clearBuffers();
			//
			SendLen = hexStringToByteArray(tAPDUInput.getText(), SendBuff);
			
			displayOut(0, 0, tmpStr);
		    
		    retCode = sendAPDUandDisplay();
		    if(retCode == FTModule.SCARD_S_SUCCESS)
		    {
		    	
		    	tmpStr="";
		    	tmpHex="";
		    	tmpStr = byteArrayToHexString(RecvBuff, RecvLen[0]) ;
		    	System.out.println("recv: " + tmpStr);
			    
			    displayOut(0, 0,  byteArrayToHexString(RecvBuff, RecvLen[0]));
		    	
		    }
		    else{
		    	displayOut(0, 0, "Transmit ...FAILED\n" );
		    }
		}
		else if(btnStatus == e.getSource())
		{
			System.out.println("btnStatus");
			int tmpWord;
			int[] state = new int[1];
			int[] readerLen = new int[1];
			String tmpStr;

			displayOut(0, 0, "Invoke SCardStatus");
			//1. Invoke SCardStatus using hCard handle
		    //   and valid reader name
			state[0]=0;
			readerLen[0]=0;
			for(int i=0; i<128; i++)
				ATRVal[i] = 0;
			
		    tmpWord = 32;
		    ATRLen[0] = tmpWord;
		    String rdrcon = (String)cbReader.getSelectedItem();  
		    
		    byte [] tmpReader	= rdrcon.getBytes();
		    byte [] readerName	= new byte[rdrcon.length()+1];
		      
		      for (int i=0; i<rdrcon.length(); i++)
		      	readerName[i] = tmpReader[i];
		      readerName[rdrcon.length()] = 0; //set null terminator
	    
		    retCode = PCSCLoader.jSCardStatus(hCard, 
		    							tmpReader, 
		    							readerLen, 
		    							state, 
		    							PrefProtocols, 
		    							ATRVal, 
		    							ATRLen);
		    
   
		   // Msg.append(""+retCode);
		    
		    
		    if (retCode != FTModule.SCARD_S_SUCCESS)
		    {
		    	
		    	displayOut(1, retCode, "");
		    	
		    }
		    else
		    {
		    	
		    	//2. Format ATRVal returned and display string as ATR value
		    	//tmpStr = "ATR Length: " & CInt(ATRLen)
		    	String strHex;
		    	tmpStr = "ATR Length: " + ATRLen[0];
		    	displayOut(3, 0, tmpStr);
		    	tmpStr = "ATR Value: ";
		    	
		    	for(int i=0; i<ATRLen[0]; i++)
		    	{
		    		
		    		//Byte to Hex conversion
					strHex = Integer.toHexString(((Byte)ATRVal[i]).intValue() & 0xFF).toUpperCase();  
					
					//For single character hex
					if (strHex.length() == 1) 
						strHex = "0" + strHex;
					
					tmpStr += " " + strHex;  
					
					//new line every 12 bytes
					if ( ((i+1) % 12 == 0) && ( (i+1) < ATRLen[0] ) )  
						tmpStr += "\n  ";	
					
		    	}
		    	
		    	displayOut(3 , 0, tmpStr);
		    	
		    	//3. Interpret dwActProtocol returned and display as active protocol
		    	tmpStr = "Active Protocol: ";
		    	
		    	switch(PrefProtocols[0])
		    	{
		    	
		    		case 1: tmpStr = tmpStr + "T=0"; break;
		    		case 2:
		    		{
		    			if (((String) cbReader.getSelectedItem()).lastIndexOf("ACR128U PICC")> -1)
		    				tmpStr = tmpStr + "T=CL"; 
		    			else
		    				tmpStr = tmpStr + "T=1"; 
		    			
		    			break;
		    		}
		    		default: tmpStr = "No protocol is defined."; break;
		    	
		    	}
		    	
		    	displayOut(3, 0, tmpStr);
		    	
		    }
		}
		else if(btnStartPpolling == e.getSource()){
			
			System.out.println("btnStartPpolling");
			
			btnStartPpolling.setEnabled(false);
			btnStopPpolling.setEnabled(true);
			
			timer = new Timer(500, pollTimer) ;
			timer.start();
		}
		else if(btnStopPpolling == e.getSource()){
			
			System.out.println("btnStopPpolling");
			
			timer.stop();
			displayOut(0, 0, "Card detection polling terminated");
			
			btnStartPpolling.setEnabled(true);
			btnStopPpolling.setEnabled(false);
		}
		else if(btnDisconnect == e.getSource()){
			
			System.out.println("btnDisconnect");
			
			retCode = PCSCLoader.jSCardDisconnect(hCard, FTModule.SCARD_UNPOWER_CARD);
			
			if(retCode != FTModule.SCARD_S_SUCCESS)
			{
				
				displayOut(1, retCode, "");
				return;
				
			}
			else
				displayOut(0, 0, "SCardDisconnect SUCCESS");
			
			btnDisconnect.setEnabled(false);
			btnTransmit.setEnabled(false);
			btnStatus.setEnabled(false);
			btnConnect.setEnabled(true);
			btnStartPpolling.setEnabled(true);
		}
		else if(btnReleaseContext == e.getSource()){
			
			System.out.println("btnReleaseContext");
			
			timer.stop();
			
			retCode = PCSCLoader.jSCardReleaseContext(hContext);
			if(retCode != FTModule.SCARD_S_SUCCESS)
			{
				displayOut(1, retCode, "");
				return;	
			}
			else
				displayOut(0, 0, "SCardRelease Context SUCCESS");
			
			btnReleaseContext.setEnabled(false);
			btnConnect.setEnabled(false);
			btnStartPpolling.setEnabled(false);
			btnStopPpolling.setEnabled(false);
			btnDisconnect.setEnabled(false);
			btnTransmit.setEnabled(false);
			btnStatus.setEnabled(false);
			
			btnListReaders.setEnabled(true);
		}
		else if(btnClear == e.getSource())
		{
			mMsg.setText("");
		}
	}
}
